#include <iostream>
#include <algorithm>
#include <vector>
#include <cmath>

using namespace std;

typedef unsigned long long ull;
typedef long long ll;
typedef long double ld;

typedef pair<ull,ull> pairULL;

pairULL coordinates[10000];

ull getArea(vector<pairULL> points){
  ld area = 0;

  for (int i = 0; i<3;++i){
    int j = (i + 1) % 3;
    area+=0.5*((ld) points[i].first * (ld) points[j].second - (ld) points[j].first * (ld) points[i].second);
  }

  return abs(area);
}

int main(){
  ios_base::sync_with_stdio(false); cin.tie(0);

  int n; cin>>n;
  int result = 0;

  for (int i = 0;i<n;++i){
    ull x,y; cin>>x>>y;

    coordinates[i] = {x,y};
  }

  if (n == 4){
    ull minArea = -1;

    for (int i = 0;i<2;++i){
      for (int j = i+1;j<3;++j){
        for (int k = j+1;k<4;++k){          
          vector<pairULL> points(3);
          points[0] = coordinates[i];
          points[1] = coordinates[j];
          points[2] = coordinates[k];
          
          auto area = getArea(points);

          if (minArea == -1) {
            minArea = area;
          }
          else{
            minArea = min(minArea,area);
          }
        }
      }
    }

    cout<<minArea;
  }

  return 0;
}